/**
 * IPT FSQM Export Report
 *
 * @package IPT FSQM Export
 * @subpackage jQuery Plugin
 * @author Swashata Ghosh <swashata@iptms.com>
 * @version 2.0
 */
;(function ( $, window, document, undefined ) {
	"use strict";
	// Create the defaults once
	var pluginName = "iptFSQMEXPExportReport",
	defaults = {
		config: {},
		mcqs: {},
		freetypes: {},
		pinfos: {},
		filters: {},
		wpnonce: '',
		ajaxurl: '',
		form_id: 0
	};

	// The actual plugin constructor
	function Plugin ( element, options ) {
		this.element = element;
		this.jElement = $( element );
		this.settings = $.extend( {}, defaults, options );
		this._defaults = defaults;
		this._name = pluginName;
		this.init();
	}

	Plugin.prototype = {
		init: function () {
			// Initialization logic
			console.log( this.settings );

			// Store some DOM
			this.progressBar = this.jElement.find( '.ipt_fsqm_exp_export_report_progressbar' );
			this.loader = this.jElement.find( '.ipt_fsqm_exp_export_report_al' );
			this.buttons = this.jElement.find( '.ipt_uif_button_container' );

			// Store some needed variables
			this.expNonce = '';
			this.expID = 0;

			// Start the reporting
			this.generateReport( 0 );
		},

		generateReport: function( doing ) {
			var that = this;
			$.post( this.settings.ajaxurl, {
				action: 'ipt_fsqm_exp_export_report',
				settings: that.settings.config,
				mcqs: that.settings.mcqs,
				freetypes: that.settings.freetypes,
				pinfos: that.settings.pinfos,
				filters: that.settings.filters,
				wpnonce: that.settings.wpnonce,
				form_id: that.settings.form_id,
				doing: doing,
				exp_nonce: that.expNonce,
				exp_id: that.expID
			}, function( response, textStatus, xhr ) {
				var format;

				// Check if null response
				if ( null === response || '' === response ) {
					that.loader.find('.ipt_uif_ajax_loader_inner').removeClass('ipt_uif_ajax_loader_animate');
					that.loader.find('.ipt_uif_ajax_loader_text').text('ServerSide Error');
					return;
				}

				// Set the progressbar
				that.progressBar.progressbar( 'option', 'value', that._numberFormat( response.done ) );

				// If 100% done, then just show the buttons
				if ( 100 == response.done ) {
					// Hide the progressBar
					that.progressBar.delay( 1000 ).slideUp( 'fast' );
					// Modify the AJAX Loader
					that.loader.find( '.ipt_uif_ajax_loader_inner' ).removeClass( 'ipt_uif_ajax_loader_animate' );
					that.loader.find( '.ipt_uif_ajax_loader_text' ).text( that.loader.data( 'done' ) );

					// Complete the buttons
					if ( 'object' === typeof( response.links ) ) {
						for ( format in response.links ) {
							that.buttons.find( 'a.ipt_fsqm_exp_export_button_' + format ).attr( 'href', response.links[ format ] );
						}
					}
					that.buttons.slideDown( 'fast' );
				// If not, then call it recursively
				} else {
					// Store the returned nonce and ID
					that.expNonce = response.exp_nonce;
					that.expID = response.exp_id;

					// Call self
					that.generateReport( ++doing );
				}
			}, 'json').fail( function( jqXHR, textStatus, errorThrown ) {
				// Stop the animation
				that.loader.find( '.ipt_uif_ajax_loader_inner' ).removeClass( 'ipt_uif_ajax_loader_animate' );
				// Tell what error has happened
				that.loader.find( '.ipt_uif_ajax_loader_text' ).text( 'AJAX ERROR: ' + textStatus + ' ' + errorThrown );
			} );
		},

		_numberFormat: function( num ) {
			var number = parseFloat( num );
			if ( isNaN( number ) ) {
				return num;
			} else {
				return ( parseInt( num * 100, 10 ) / 100 );
			}
		}
	};

	var methods = {
		init: function( options ) {
			return this.each(function() {
				if ( ! $.data( this, "plugin_" + pluginName ) ) {
					$.data( this, "plugin_" + pluginName, new Plugin( this, options ) );
				}
			});
		}
	};

	// A really lightweight plugin wrapper around the constructor,
	// preventing against multiple instantiations
	$.fn[ pluginName ] = function ( method ) {
		if( methods[method] ) {
			return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ) );
		} else if ( typeof( method ) == 'object' || !method ) {
			methods.init.apply(this, arguments);
		} else {
			$.error( 'Method ' + method + ' does not exist on jQuery.' + pluginName );
		}

		// chain jQuery functions
		return this;
	};

})( jQuery, window, document );
