(function() {
	"use strict";

	iptFSQMTMMenu.addons[iptFSQMTMMenu.addons.length] = function( editor, url, forms, themes ) {
		var exports = [], i;
		if ( iptFSQMEXPtmce.exports.length ) {
			for ( i in iptFSQMEXPtmce.exports ) {
				exports[exports.length] = {
					text: iptFSQMEXPtmce.exports[i].name + ' (' + iptFSQMEXPtmce.exports[i].created + ')',
					value: iptFSQMEXPtmce.exports[i].id
				};
			}
		}

		// Prepopulate the trends body
		var trendsWizardBody = [];
		// Add the exp_id
		trendsWizardBody[ trendsWizardBody.length ] = {
			type   : 'listbox',
			name   : 'fsqmEXPID',
			label  : iptFSQMEXPtmce.l10n.pid,
			values : exports
		};
		// Add visualization column
		trendsWizardBody[ trendsWizardBody.length ] = {
			type: 'textbox',
			name: 'fsqmTVC',
			label: iptFSQMTML10n.l10n.itvc,
			value: iptFSQMTML10n.l10n.itvcv
		};
		// Report Data Customization
		trendsWizardBody[ trendsWizardBody.length ] = {
			type: 'spacer'
		};
		trendsWizardBody[ trendsWizardBody.length ] = {
			type: 'container',
			html: '<h2 style="font-weight: bold;">' + iptFSQMTML10n.l10n.twb1.rdc + '</h2>'
		};
		// Loop through all report data and add checkboxes
		for ( i in iptFSQMTMMenu.rdata ) {
			trendsWizardBody[ trendsWizardBody.length ] = iptFSQMTMMenu.rdata[ i ];
		}
		// Report Appearance
		trendsWizardBody[ trendsWizardBody.length ] = {
			type: 'spacer'
		};
		trendsWizardBody[ trendsWizardBody.length ] = {
			type: 'container',
			html: '<h2 style="font-weight: bold;">' + iptFSQMTML10n.l10n.twb1.ra + '</h2>'
		};
		// Loop through all report data and add checkboxes
		for ( i in iptFSQMTMMenu.rappe ) {
			trendsWizardBody[ trendsWizardBody.length ] = iptFSQMTMMenu.rappe[ i ];
		}

		return {
			text: iptFSQMEXPtmce.l10n.ps,
			icon: 'icon ipt-icomoon-stats',
			onclick: function() {
				var height = jQuery(window).height(), width = jQuery(window).width();
				var win = editor.windowManager.open({
					title: iptFSQMTML10n.l10n.slabel + iptFSQMEXPtmce.l10n.ps,
					height: ( height < 200 ) ? ( height - 50 ) : ( height - 200 ),
					width: ( width < 900 ) ? ( width - 50 ) : 800,
					autoScroll: true,
					classes: 'ipt-fsqm-panel',
					body: trendsWizardBody,
					onsubmit: function( e ) {
						// Store the settings
						var rdataConfig = {},
						rappearanceConfig = {},
						visualizationTitle = e.data.fsqmTVC,
						// Store some needed variables
						expID = e.data.fsqmEXPID,
						i;

						// Store the report data
						for ( i in iptFSQMTML10n.trends.reportData ) {
							rdataConfig[ iptFSQMTML10n.trends.reportData[ i ].value ] = false;
							if ( true === e.data[ 'fsqmTW1rd' + iptFSQMTML10n.trends.reportData[ i ].value ] ) {
								rdataConfig[ iptFSQMTML10n.trends.reportData[ i ].value ] = true;
							}
						}

						// Store the report appearance
						for ( i in iptFSQMTML10n.trends.reportAppearance ) {
							rappearanceConfig[ iptFSQMTML10n.trends.reportAppearance[ i ].value ] = false;
							if ( true === e.data[ 'fsqmTW1ra' + iptFSQMTML10n.trends.reportAppearance[ i ].value ] ) {
								rappearanceConfig[ iptFSQMTML10n.trends.reportAppearance[ i ].value ] = true;
							}
						}

						// Interrupt here and show an ajax loader
						editor.windowManager.open({
							title: iptFSQMTML10n.l10n.slabel + iptFSQMTML10n.l10n.it,
							height: 100,
							width: 500,
							body: [
								{
									type: 'container',
									html: iptFSQMTML10n.l10n.ajax
								}
							]
						});

						// Prep the ajax call
						jQuery.get( ajaxurl, {
							action: 'ipt_fsqm_exp_export_tmce_details',
							wpnonce: iptFSQMEXPtmce.tmceDetailsNonce,
							exp_id: expID
						}, function( data ) {
							// Close the previous window
							editor.windowManager.close();
							// Check for data response
							if ( 'string' === typeof( data ) ) {
								editor.windowManager.alert( 'Invalid Request! Please refresh the page and try again. Error Code: ' + data );
								return;
							}
							if ( null == data || 'object' !== typeof( data ) ) {
								editor.windowManager.alert( 'Error! Invalid Server Response' );
								return;
							}

							var body = [], i, j, win, chartType, toggleType;
							// Some state variable for bypassing
							// weird tinymce programmatic checkbox change issue
							var onGoingCheckMCQ = false,
							onGoingCheckFreeType = false,
							onGoingCheckpInfo = false;

							// MCQ Questions
							if ( data.mcqs.length ) {
								for ( i in data.mcqs ) {
									// Add the main questions
									body[body.length] = {
										type   : 'checkbox',
										name   : 'fsqmMID' + data.mcqs[i].value,
										label  : data.mcqs[i].value == 'all' ? iptFSQMTML10n.l10n.twb2.sm : '',
										text   : data.mcqs[i].text,
										checked : data.mcqs[i].value == 'all' ? true : false,
										onChange: function( e ) {
											if ( onGoingCheckMCQ ) {
												return;
											}
											onGoingCheckMCQ = true;
											var elm;
											// Change Show All
											if ( this._name != 'fsqmMIDall' ) {
												elm = win.find( '#fsqmMIDall' );
												elm.checked( false );
												elm.value( false );
											// Disable other checkboxes
											} else {
												for ( i in data.mcqs ) {
													if ( data.mcqs[i].value != 'all' ) {
														elm = win.find( '#fsqmMID' + data.mcqs[i].value );
														elm.checked( false );
														elm.value( false );
													}
												}
											}
											onGoingCheckMCQ = false;
										}
									};
									// Add the Chart type
									if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.mcqs[ i ].type ] ) ) {
										chartType = [];
										for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.mcqs[ i ].type ] ) {
											if ( 'default' != j ) {
												chartType[ chartType.length ] = {
													text: iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.mcqs[ i ].type ][ j ],
													value: j
												};
											}
										}
										body[ body.length ] = {
											label: iptFSQMTML10n.l10n.twb2.sct,
											type: 'listbox',
											name: 'fsqmMID' + data.mcqs[i].value + 'ctype',
											values: chartType,
											value: iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.mcqs[ i ].type ].default
										};
									}
									// Add the Toggle options
									if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ] ) ) {
										for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ] ) {
											body[ body.length ] = {
												type: 'checkbox',
												label: iptFSQMTML10n.trends.cTypeToggle.toggle_labels[ iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ][ j ] ],
												name: 'fsqmMID' + data.mcqs[i].value + 'toggle' + iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ][ j ],
												checked: true
											};
										}
									}
									// Add a spacer
									body[ body.length ] = {
										type: 'spacer'
									};
								}
								body[ body.length ] = {
									type: 'spacer'
								};
							}

							// Freetype Questions
							if ( data.freetypes.length ) {
								for ( i in data.freetypes ) {
									// Just add the main question
									body[body.length] = {
										type   : 'checkbox',
										name   : 'fsqmFID' + data.freetypes[i].value,
										label  : data.freetypes[i].value == 'all' ? iptFSQMTML10n.l10n.twb2.sf : '',
										text   : data.freetypes[i].text,
										checked : data.freetypes[i].value == 'all' ? true : false,
										onChange: function( e ) {
											if ( onGoingCheckFreeType ) {
												return;
											}
											onGoingCheckFreeType = true;
											var elm;
											// Change Show All
											if ( this._name != 'fsqmFIDall' ) {
												elm = win.find( '#fsqmFIDall' );
												elm.checked( false );
												elm.value( false );
											// Disable other checkboxes
											} else {
												for ( i in data.freetypes ) {
													if ( data.freetypes[i].value != 'all' ) {
														elm = win.find( '#fsqmFID' + data.freetypes[i].value );
														elm.checked( false );
														elm.value( false );
													}
												}
											}
											onGoingCheckFreeType = false;
										}
									};
									// No need to account for ctype and toggles
									// Cause these are text types
								}
								body[ body.length ] = {
									type: 'spacer'
								};
							}

							// Insert pinfo elements
							if ( data.pinfos.length ) {
								for ( i in data.pinfos ) {
									// Add the main questions
									body[body.length] = {
										type   : 'checkbox',
										name   : 'fsqmPID' + data.pinfos[i].value,
										label  : data.pinfos[i].value == 'all' ? iptFSQMTML10n.l10n.twb2.sp : '',
										text   : data.pinfos[i].text,
										checked : data.pinfos[i].value == 'all' ? true : false,
										onChange: function( e ) {
											if ( onGoingCheckpInfo ) {
												return;
											}
											onGoingCheckpInfo = true;
											var elm;
											// Change Show All
											if ( this._name != 'fsqmPIDall' ) {
												elm = win.find( '#fsqmPIDall' );
												elm.checked( false );
												elm.value( false );
											// Disable other checkboxes
											} else {
												for ( i in data.pinfos ) {
													if ( data.pinfos[i].value != 'all' ) {
														elm = win.find( '#fsqmPID' + data.pinfos[i].value );
														elm.checked( false );
														elm.value( false );
													}
												}
											}
											onGoingCheckpInfo = false;
										}
									};
									// Add the Chart type
									if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.pinfos[ i ].type ] ) ) {
										chartType = [];
										for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.pinfos[ i ].type ] ) {
											if ( 'default' != j ) {
												chartType[ chartType.length ] = {
													text: iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.pinfos[ i ].type ][ j ],
													value: j
												};
											}
										}
										body[ body.length ] = {
											label: iptFSQMTML10n.l10n.twb2.sct,
											type: 'listbox',
											name: 'fsqmPID' + data.pinfos[i].value + 'ctype',
											values: chartType,
											value: iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.pinfos[ i ].type ].default
										};
									}
									// Add the Toggle options
									if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ] ) ) {
										for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ] ) {
											body[ body.length ] = {
												type: 'checkbox',
												label: iptFSQMTML10n.trends.cTypeToggle.toggle_labels[ iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ][ j ] ],
												name: 'fsqmPID' + data.pinfos[i].value + 'toggle' + iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ][ j ],
												checked: true
											};
										}
									}
									// Add a spacer
									body[ body.length ] = {
										type: 'spacer'
									};
								}
							}

							var height = jQuery(window).height(), width = jQuery(window).width();

							win = editor.windowManager.open({
								title: iptFSQMTML10n.l10n.slabel + iptFSQMTML10n.l10n.it,
								height: ( height - 200 ),
								width: ( width < 900 ) ? ( width - 50 ) : 800,
								autoScroll: true,
								classes: 'ipt-fsqm-panel',
								body: body,
								onsubmit: function( e ) {
									var i, j;
									// Get the basics
									var shortcode = '[ipt_fsqm_ptrends id="' + expID +
										'" title="' + visualizationTitle + '"';

									// Now add the mcqs ( if any )
									if ( data.mcqs.length ) {
										shortcode += ' mcq_ids="';
										// Form the JSON and insert it too
										var mcqJSON = {
											charttype: {}, // We need charttype (case sensitive) beacuse it is expected by PHP
											toggles: {}, // We need toggles (case sensitive) because it is expected by PHP
										};
										if ( e.data.fsqmMIDall === true ) {
											shortcode += 'all';
											for ( i in data.mcqs ) {
												// Look for chart
												if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.mcqs[ i ].type ] ) ) {
													mcqJSON.charttype[ data.mcqs[ i ].value ] = e.data[ 'fsqmMID' + data.mcqs[ i ].value + 'ctype' ];
												}

												// Look for toggles
												if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ] ) ) {
													mcqJSON.toggles[ data.mcqs[ i ].value ] = {};
													for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ] ) {
														mcqJSON.toggles[ data.mcqs[ i ].value ][ iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ][ j ] ] = e.data[ 'fsqmMID' + data.mcqs[i].value + 'toggle' + iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ][ j ] ];
													}
												}
											}
										} else {
											var mcq_ids = [];
											for ( i in data.mcqs ) {
												if ( e.data['fsqmMID' + data.mcqs[i].value ] === true ) {
													mcq_ids.push( data.mcqs[i].value );

													// Look for chart
													if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.mcqs[ i ].type ] ) ) {
														mcqJSON.charttype[ data.mcqs[ i ].value ] = e.data[ 'fsqmMID' + data.mcqs[ i ].value + 'ctype' ];
													}

													// Look for toggles
													if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ] ) ) {
														mcqJSON.toggles[ data.mcqs[ i ].value ] = {};
														for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ] ) {
															mcqJSON.toggles[ data.mcqs[ i ].value ][ iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ][ j ] ] = e.data[ 'fsqmMID' + data.mcqs[i].value + 'toggle' + iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.mcqs[ i ].type ][ j ] ];
														}
													}
												}
											}
											shortcode += mcq_ids.join( ',' );
										}

										shortcode += '" mcq_config=\'' + JSON.stringify( mcqJSON ) + '\'';
									}

									// Add freetype
									if ( data.freetypes.length ) {
										shortcode += ' freetype_ids="';
										if ( true === e.data.fsqmFIDall ) {
											shortcode += 'all';
										} else {
											var freetype_ids = [];
											for ( i in data.freetypes ) {
												if ( true === e.data[ 'fsqmFID' + data.freetypes[ i ].value ] ) {
													freetype_ids.push( data.freetypes[ i ].value );
												}
											}
											shortcode += freetype_ids.join( ',' );
										}
										shortcode += '"';
									}

									// Add pinfo
									if ( data.pinfos.length ) {
										shortcode += ' pinfo_ids="';
										// Form the JSON and insert it too
										var pinfoJSON = {
											charttype: {}, // We need charttype (case sensitive) beacuse it is expected by PHP
											toggles: {}, // We need toggles (case sensitive) because it is expected by PHP
										};
										if ( e.data.fsqmPIDall === true ) {
											shortcode += 'all';
											for ( i in data.pinfos ) {
												// Look for chart
												if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.pinfos[ i ].type ] ) ) {
													pinfoJSON.charttype[ data.pinfos[ i ].value ] = e.data[ 'fsqmPID' + data.pinfos[ i ].value + 'ctype' ];
												}

												// Look for toggles
												if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ] ) ) {
													pinfoJSON.toggles[ data.pinfos[ i ].value ] = {};
													for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ] ) {
														pinfoJSON.toggles[ data.pinfos[ i ].value ][ iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ][ j ] ] = e.data[ 'fsqmPID' + data.pinfos[ i ].value + 'toggle' + iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ][ j ] ];
													}
												}
											}
										} else {
											var pinfo_ids = [];
											for ( i in data.pinfos ) {
												if ( e.data['fsqmPID' + data.pinfos[i].value ] === true ) {
													pinfo_ids.push( data.pinfos[i].value );

													// Look for chart
													if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_chart_types[ data.pinfos[ i ].type ] ) ) {
														pinfoJSON.charttype[ data.pinfos[ i ].value ] = e.data[ 'fsqmPID' + data.pinfos[ i ].value + 'ctype' ];
													}

													// Look for toggles
													if ( "undefined" !== typeof( iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ] ) ) {
														pinfoJSON.toggles[ data.pinfos[ i ].value ] = {};
														for ( j in iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ] ) {
															pinfoJSON.toggles[ data.pinfos[ i ].value ][ iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ][ j ] ] = e.data[ 'fsqmPID' + data.pinfos[ i ].value + 'toggle' + iptFSQMTML10n.trends.cTypeToggle.possible_toggle_types[ data.pinfos[ i ].type ][ j ] ];
														}
													}
												}
											}
											shortcode += pinfo_ids.join( ',' );
										}

										shortcode += '" pinfo_config=\'' + JSON.stringify( pinfoJSON ) + '\'';
									}

									// Add data variables
									shortcode += " data='" + JSON.stringify( rdataConfig ) + "'";

									// Add appearance variable
									shortcode += " appearance='" + JSON.stringify( rappearanceConfig ) + "'";

									shortcode += ']';
									editor.insertContent( '<br />' + shortcode + '<br />' );
								}
							});
						} ).fail( function() {
							editor.windowManager.close();
							editor.windowManager.alert('Error! Could not connect to server');
						} );
					}
				});
			}
		}
	}

})();
